#!/bin/bash -l
#SBATCH --job-name="S1_MODELNO"
#SBATCH --account="d411-hector"
#SBATCH --time=03:00:00
#SBATCH --nodes=1	
#SBATCH --partition=gpu
#SBATCH --qos=gpu
#SBATCH --gres=gpu:1

module load nvidia/nvhpc

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export CRAY_CUDA_MPS=1

for ((time=INIT; time<ENDY; time=time+5))
do
	sed -i -e "s/INTERVAL/${time}/" S2_MODELNO_MESHID.ini
	srun ./bin/MonoAlg3D -c S2_MODELNO_MESHID.ini
	sed -i -e "s/${time}/INTERVAL/" S2_MODELNO_MESHID.ini
done






